import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { mutationResponse } from "../../util/processResponse.js";

const URL = `${BASE_API_URL_STG}/user/profile/update`;

const initialState = {
    postUserInfo: null,
    loading: false,
};

export const postUpdateUserProfile = createAsyncThunk(
    "user/postUpdateUserProfile",
    async (obj) => {
        try {
            const { access_token, formData } = obj;
            const response = await mutationResponse(
                URL,
                "POST",
                formData,
                access_token
            );
            return response;
        } catch (err) {
            return;
        }
    }
);

const postUpdateUserProfileSlice = createSlice({
    name: "user",
    initialState,
    reducers: {},
    extraReducers: (builder) => {
        builder.addCase(postUpdateUserProfile.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(
            postUpdateUserProfile.fulfilled,
            (state, { payload }) => {
                state.postUserInfo = payload;
                state.loading = false;
            }
        );
        builder.addCase(postUpdateUserProfile.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default postUpdateUserProfileSlice.reducer;
